function [TestBad,TestGood]=udp_tests(skt)
% udp_tests.m Peek poke tests
%Ian Stothers 2021
% Serial bits added
% 10-June- 2023 - Ian Stothers

if (nargin<1)
 skt=  "192.168.1.4";
end
if (ischar(skt))
  skt=sktopen(skt);
endif
%udpreset(skt);
pause(0.5);
global TestGood=0;
global TestBad=0;
global UDP_RX_ERRORS=0;
global UDP_TX_ERRORS=0;

TestGood=0;
TestBad=0;
udp_num_test(skt,"Test_sint8",[ -128 -1 0 1 64 127] )
udp_num_test(skt,"Test_uint8",[0 1 128 151 200 255])
udp_num_test(skt,"Test_uint16le",[0 1 128 512 4095 65535])
udp_num_test(skt,"Test_sint16le",[-32768  -1 0 1  512 32767])
udp_num_test(skt,"Test_uint32le",[0 10 1025 2^22 2^31 (2^32)-1])
udp_num_test(skt,"Test_sint32le",[-(2^31),1000,1 0 1 (2^31)-1])
udp_num_test(skt,"Test_float32le",single([-1.1111e38 -1          -1e-38 0 1   1.1111e38]))
udp_num_test(skt,"Test_float32le",single([-2         -1.111e-18  -1e-38 1e-38 3 1.12311e18]))
%n=10;tic;for x=1:n;a=udpget(skt,"DMA_Buffer_0");end;t=toc;b=max(size(a))*n;bps=b/t; printf("Bytes per second reads = %f\n",bps)
n=10;tic;for x=1:n;a=udpget(skt,"Screen");end;t=toc;b=prod(size(a))*n;bps=b/t; printf("Bytes per second reads = %f\n",bps)
return
ip=skt.ip;
ipn=udpget(skt,'IPConfig')(1:4);
oldip=sprintf("%d.%d.%d.%d",ipn(1),ipn(2),ipn(3),ipn(4));
[bpsw]=udp_write_test(skt,10);
n=50;tic;for x=1:n;a=udpget(skt,"ETH_UDP_Xmits");end;t=toc;;tps=n/t; printf("UDP transactions per second = %f\n",tps)
tic; clear skt; skt=sktopen(ip);t=toc; printf("UDP registry get time (seconds) for %d entries = %f\n",size(skt.name)(1),t)
printf("\n");
printf("Tests Passed - %d\n",TestGood);
printf("Tests Failed - %d\n",TestBad);

if(0)
printf("IP Programme test %s to 192.168.1.3\n",ip);
newip='192.168.1.3';
udpprogip(skt,newip);
if (max(size(find(skt.ip=='.')))==1)
    idx=find(newip=='.');
    skt.ip=(newip((idx(2)+1):end));
else
    sktclose(skt);
    skt=sktopen(newip);
endif
printf("IP Programme test back to %s\n",oldip);
udpprogip(skt,oldip);
if (max(size(find(skt.ip=='.')))==1)
    idx=find(oldip=='.');
    skt.ip=(oldip((idx(2)+1):end));
else
    sktclose(skt);
    skt=sktopen(oldip);
endif
TestGood=TestGood+1;

endif
printf("Tests Passed - %d\n",TestGood);
printf("Tests Failed - %d\n",TestBad);
end
